/****************************************************************************
**
** Copyright (C) 2025 David C. Partridge
**
** BSD License Usage
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of DeepSkyStacker nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
**
****************************************************************************/
// griddata.cpp : Implementation file
//
// Based upon plgridd.c which is part of PLPlot:
// Copyright (C) 2004  Joao Cardoso
// Copyright (C) 2004-2015 Alan W. Irwin
//
#include <QPromise>
#include <QMessageBox>
#include <vector>

#include "griddata.h"

#ifdef WITH_NN
extern "C"
{
#include "nn/nn.h"
#include "nn/delaunay.h"
}
#endif

#ifdef WITH_CSA
extern "C"
{
#include "csa.h"
}
#endif

namespace DSS
{
    //--------------------------------------------------------------------------
    //
    // GridData::interpolate(): grids data from irregularly sampled data.
    //
    //    Real world data is frequently irregularly sampled, but most 3D plots
    //    require regularly gridded data. This function does exactly this
    //    using several methods:
    //    Irregularly sampled data x[npts], y[npts], z[npts] is gridded into
    //    zg[nptsx, nptsy] according to method 'type' and grid information
    //    xg[nptsx], yg[nptsy].
    //
    //    'type' can be:
    //
    //       GRID_CSA:    Bivariate Cubic Spline approximation (1)
    //       GRID_NNIDW:  Nearest Neighbors Inverse Distance Weighted
    //       GRID_NNLI:   Nearest Neighbors Linear Interpolation
    //       GRID_NNAIDW: Nearest Neighbors Around Inverse Distance Weighted
    //       GRID_DTLI:   Delaunay Triangulation Linear Interpolation (2)
    //       GRID_NNI:    Natural Neighbors interpolation (2)
    //
    // (1): Copyright 2000-2002 CSIRO Marine Research, Pavel Sakov's csa library
    // (2): Copyright 2002 CSIRO Marine Research, Pavel Sakov's nn library
    //
    //--------------------------------------------------------------------------
    void
        GridData::interpolate(QPromise<void>& promise,
            const std::vector<double>& x, const std::vector<double>& y, const std::vector<double>& z,
            const std::vector<double>& xg, const std::vector<double>& yg, std::vector<double>& zg,
            InterpolationType type, float data)
    {
    }

}