#pragma once
/****************************************************************************
**
** Copyright (C) 2025 David C. Partridge
**
** BSD License Usage
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of DeepSkyStacker nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
**
****************************************************************************/
// griddata.h : header file
//
namespace DSS
{
    class GridData
    {
    public:
        enum class InterpolationType
        {
            GRID_CSA = 0,   // Bivariate Cubic Spline Approximation
            GRID_NNAIDW,    // Natural Neighbors with Inverse Distance Weighting
            GRID_NNLI,      // Natural Neighbors with Linear Interpolation
            GRID_NNIDW,     // Natural Neighbors with Inverse Distance Weighting (KNN)
            GRID_DTLI,      // Delaunay Triangulation Linear Interpolation
            GRID_NNI        // Natural Neighbors Interpolation
        };

        GridData()
        {
        };

        GridData(const GridData&) = default;
        GridData& operator=(const GridData&) = default;
        GridData(GridData&&) = default;

        ~GridData()
        {
        };

        //void test([[maybe_unused]]QPromise<void>& promise) const {}
        void test() const {}

        void
            interpolate(QPromise<void>& promise,
                const std::vector<double>& x, const std::vector<double>& y, const std::vector<double>& z,
                const std::vector<double>& xg, const std::vector<double>& yg, std::vector<double>& zg,
                InterpolationType type, float data = 0.0f);
    };
}